<?php
////////////////////////////////////
// DYNAMICALLY CREATE THE CSS //////
////////////////////////////////////

// be sure it is included
include_once(GG_DIR .'/classes/static/gg_static.php');

// is RTL?
$rtl = (get_option('gg_rtl_mode') == '1') ? true : false;
?>




/* preloader */
<?php
include_once(GG_DIR .'/classes/loaders_switch.php');
gg_loaders_switch();
?>


<?php if(get_option('gg_disable_rclick')) : ?>
/* right click protection - code for iphone */
.gg_gallery_wrap *, .gg_lcms_slider *, #lcl_wrapper * {
    -webkit-touch-callout: none; 
    -webkit-user-select: none;
}
<?php endif; ?>



<?php if(get_option('gg_img_shadow') == 'outshadow') : ?>
.gg_gallery_wrap:not(.gg_collection_wrap), 
.gg_itg_container,
.gg_coll_outer_container {
	padding: 3px;
}
<?php elseif(get_option('gg_img_shadow') == 'outline') : ?>
.gg_gallery_wrap:not(.gg_collection_wrap), 
.gg_itg_container,
.gg_coll_outer_container {
	padding: 1px;
}
<?php endif; ?>


/* image border, radius and shadow */
.gg_standard_gallery .gg_img,
.gg_columnized_gallery .gg_img,
.gg_masonry_gallery .gg_img_inner,
.gg_string_gallery .gg_img,
.gg_itg_container .gg_img,
.gg_coll_img {
	<?php
	$border = (int)get_option('gg_img_border');
	if(!$border) {
		echo 'border: none;';
	}
	else {
		echo 'border: '.$border.'px solid '.get_option('gg_img_border_color', '#444').';';
		echo 'background-color: '.get_option('gg_img_border_color', '#444').';';
	}
	?>
    
    <?php 
	$radius = (int)get_option('gg_img_radius');
	if($radius && (int)$radius  > 0) {
		echo 'border-radius: '.$radius.'px;';	
	}
	?>
	
	<?php 
	// soft shadow or outline
	$shadow_outline = get_option('gg_img_shadow');
	
	if($shadow_outline == 'outshadow') {
		echo 'box-shadow: 0 0 2px rgba(25,25,25,0.4);';
	}
	elseif($shadow_outline == 'outline') {
		echo 'box-shadow: 0 0 0 1px '. get_option('gg_img_outline_color', '#777777') .';';
	}
	?>
}


<?php 
/* OVERLAYS */
$overlay_type = get_option('gg_overlay_type'); 


// color
$bg_color = get_option('gg_main_ol_color', 'rgba(253, 253, 253, 0.3)');
$txt_color = get_option('gg_main_ol_txt_color', '#222');
	
if(!empty($overlay_type)) : 
?>
/* main overlay */
.gg_gallery_wrap .gg_img .gg_main_overlay {
	<?php
	echo '
	color: '.$txt_color.';
	background: '.$bg_color.';
	text-shadow: 0 0 0 '. gg_static::hex2rgba($txt_color, 0.85) .';
	';  
	?>
}
<?php
endif;


/* fullimage title layer */
?>
.gg_ol_full_mode .gg_img_title {
	border-color: <?php echo gg_static::hex2rgba($txt_color, 0.15) ?>; 
	background: <?php echo get_option('gg_main_ol_full_txt_bg', '#fdfdfd') ?>;
}
<?php



/* secondary overlay */
if($overlay_type == 'both') : ?>

.gg_gallery_wrap div.gg_img:not(.gg_coll_img):not(.gg_linked_img) .gg_sec_overlay span:before {
<?php
switch(get_option('gg_sec_ol_icon', 'eye')) {
	case 'eye': default :
		?>content: "\f06e"; <?php
		break;
		
	case 'camera':
		?>content: "\f030"; font-weight: bold;<?php
		break;
		
	case 'magnifier':
		?>content: "\f002"; font-weight: bold;<?php
		break;
		
	case 'image':
		?>content: "\f03e"; font-weight: bold;<?php
		break;				
}
?>
}
.gg_both_ol .gg_sec_overlay {
	background: <?php echo get_option('gg_sec_ol_color', '#eee'); ?>;
}
.gg_gallery_wrap .gg_img .gg_sec_overlay span {
	color: <?php echo get_option('gg_icons_col', '#fcfcfc') ?>;
}
<?php 
endif; // overlays end



/* slow image zoom on hover */
if(get_option('gg_slowzoom_ol')) : ?>
.gg_gallery_wrap:not(.gg_car_nocrop) .gg_main_img_wrap,
.gg_itg_wrap .gg_main_img_wrap {
	transition:	transform .5s ease-out;	
	transform: scale(1) translateZ(0); /* set default state to avoid bad "jumps" on state change */
}
.gg_gallery_wrap:not(.gg_car_nocrop) .gg_img:hover .gg_main_img_wrap,
.gg_gallery_wrap:not(.gg_car_nocrop) .gg_img.gg_touch_on .gg_main_img_wrap,
.gg_itg_wrap .gg_img:hover .gg_main_img_wrap {
	transform: scale(1.03);
	transition-duration: 4s;
}
.gg_itg_monoimage .gg_img:nth-child(2):hover .gg_main_img_wrap,
.gg_itg_monoimage .gg_img:nth-child(3):hover .gg_main_img_wrap {
	transform: scale(1) !important;
}
<?php endif; ?>



/* extra image effects */
<?php if(get_option('gg_img_fx_behavior')) : 
    $extra_fx_val = 'filter: 
        blur('. (float)get_option('gg_img_fx_blur', 0) .'px) 
        brightness('. (float)get_option('gg_img_fx_brightness', 100) .'%) 
        contrast('. (float)get_option('gg_img_fx_contrast', 1) .') 
        grayscale('. (float)get_option('gg_img_fx_grayscale', 0) .'%) 
        hue-rotate('. (float)get_option('gg_img_fx_hue', 0) .'deg) 
        invert('. (float)get_option('gg_img_fx_invert', 0) .'%) 
        saturate('. (float)get_option('gg_img_fx_saturate', 1) .')     
        sepia('. (float)get_option('gg_img_fx_sepia', 0) .'%);';

    if(get_option('gg_img_fx_behavior') == 'hover_status') {
        $efxv_default = '';    
        $efxv_hover = $extra_fx_val;       
    } 
    else {
        $efxv_default = $extra_fx_val;
        $efxv_hover = 'filter: none;';
    }
?>
.gg_gallery_wrap .gg_photo {
    <?php echo $efxv_default ?>
	transition: filter .4s ease;
}
.gg_gallery_wrap .gg_img:hover .gg_photo {
	<?php echo $efxv_hover; ?>
}
<?php endif; ?>




/* collections - texts under images */
.gg_coll_img .gg_main_overlay_under .gg_img_title_under {
	color: <?php echo get_option('gg_txt_u_title_color', '#444444') ?>;
}
.gg_coll_img .gg_main_overlay_under .gg_img_descr_under {
	color: <?php echo get_option('gg_txt_u_descr_color', '#555555') ?>;
}



<?php /* tags + collection filters + back to collection button */ ?>
.gg_filter,
.gg_tags_wrap {
	text-align: <?php echo get_option('gg_filters_align', 'left'); ?>; 
}
.gg_filter a.ggf,
.gg_tag,
.gg_coll_back_to_new_style,
.gg_gall_search_form input {	
	color: <?php echo get_option('gg_filters_txt_color', '#444444'); ?>;
    font-size: <?php echo get_option('gg_filters_font_size', 15) ?>px;
    
    <?php $fp = get_option('gg_filters_padding', array(6, 12)) ?>
    padding: <?php echo (int)$fp[0] ?>px <?php echo (int)$fp[1] ?>px;
}
.gg_filter a.ggf:hover,
.gg_tag:hover,
.gg_coll_back_to_new_style:hover {	
	color: <?php echo get_option('gg_filters_txt_color_h', '#666666'); ?> !important;
}
.gg_filter a.ggf.gg_cats_selected,
.gg_filter a.ggf.gg_cats_selected:hover,
.gg_tag.gg_tag_sel,
.gg_tag.gg_tag_sel:hover {	
	color: <?php echo get_option('gg_filters_txt_color_sel', '#333'); ?> !important;
}
.gg_textual_filters .gg_cats_selected:after,
.gg_textual_filters .gg_tag_sel {
	text-shadow: 0 0.01em 0 <?php echo get_option('gg_filters_txt_color_sel', '#333'); ?>;
}

.gg_btn_filters a.ggf,
.gg_btn_filters .gg_tag,
.gg_coll_back_to_new_style,
select.gg_mobile_filter_dd,
.gg_gall_search_form input {	
	background: <?php echo get_option('gg_filters_bg_color', '#ffffff'); ?>;
    border: <?php echo (int)get_option('gg_filters_border_w', 1) ?>px solid <?php echo get_option('gg_filters_border_color', '#999999') ?>;
    border-radius: <?php echo (int)get_option('gg_filters_radius', 2) ?>px;
}
.gg_btn_filters a.ggf:hover,
.gg_btn_filters .gg_tag:hover,
.gg_coll_back_to_new_style:hover {	
	background: <?php echo get_option('gg_filters_bg_color_h', '#ffffff') ?>;
    border-color: <?php echo get_option('gg_filters_border_color_h', '#666666') ?>;
}
.gg_btn_filters a.ggf.gg_cats_selected,
.gg_btn_filters a.ggf.gg_cats_selected:hover,
.gg_btn_filters .gg_tag.gg_tag_sel,
.gg_btn_filters .gg_tag.gg_tag_sel:hover {	
	background: <?php echo get_option('gg_filters_bg_color_sel', '#ffffff'); ?>;
    border-color: <?php echo get_option('gg_filters_border_color_sel', '#555555'); ?>;
}
.gg_textual_filters .ggf:after,
.gg_textual_filters .gg_tag:after {
	background: <?php echo get_option('gg_filters_bg_color_sel', '#ffffff'); ?>;
}

<?php 
// responsive part for dropdown filters
if(get_option('gg_dd_mobile_filter')) :
?>
@media screen and (max-width: 760px) { 
	.gg_filter,
    .gg_tag {
    	display: none !important;
    }
    .gg_mobile_filter_dd {
    	display: block !important;
    }
}
<?php endif; ?>



<?php /* searchbox */ ?>
.gg_gall_search_form input,
.gg_gall_search_form i {
	color: <?php echo get_option('gg_search_txt_color', '#707070'); ?>;
}
.gg_gall_search_form input {
	background: <?php echo get_option('gg_search_bg_color', '#f5f5f5'); ?>;
    border-color: <?php echo get_option('gg_search_border_color', '#f1f1f1'); ?>;
}
.gg_gall_search_form:hover input,
.gg_gall_search_form:hover i,
.gg_gall_search_form:active input,
.gg_gall_search_form:active i,
.gg_gall_search_form:focus input,
.gg_gall_search_form:focus i {
	color: <?php echo get_option('gg_search_txt_color_h', '#5e5e5e'); ?>;
}
.gg_gall_search_form:hover input,
.gg_gall_search_form:active input,
.gg_gall_search_form:focus input {
	background: <?php echo get_option('gg_search_bg_color_h', '#fff'); ?>;
    border: <?php echo (int)get_option('gg_filters_border_w', 1) ?>px solid <?php echo get_option('gg_search_border_color_h', '#f0f0f0') ?>;
    
    <?php $fp = get_option('gg_filters_padding', array(6, 12)) ?>
    padding: <?php echo (int)$fp[0] ?>px <?php echo (int)$fp[1] ?>px;
}




<?php /* pagination elements */ ?>
.gg_standard_pag i,
.gg_num_btns_wrap > div {
	color: <?php echo get_option('gg_pag_txt_col', '#707070') ?>;
}
.gg_standard_pag:not(.gg_detach_arr),
.gg_standard_pag.gg_detach_arr > div,
.gg_infinite_scroll,
.gg_num_btns_wrap > div {
	border: 1px solid <?php echo get_option('gg_pag_border_col', '#f5f5f5') ?>;
	background: <?php echo get_option('gg_pag_bg_col', '#f5f5f5') ?>;
}
.gg_standard_pag:not(.gg_only_arr) .gg_nav_mid,
.gg_infinite_scroll div {
	color: <?php echo get_option('gg_pag_txt_col', '#707070') ?>;
}
.gg_standard_pag.gg_monoblock:before {
	background: <?php echo get_option('gg_pag_border_col', '#f5f5f5') ?>;
}
.gg_dots_pag_wrap > div {
	background: <?php echo get_option('gg_pag_bg_col', '#f5f5f5') ?>;
}

.gg_standard_pag:not(.gg_only_arr) > div:not(.gg_nav_mid):not(.gg_pag_disabled):hover,
.gg_infinite_scroll:hover,
.gg_standard_pag.gg_only_arr > div:not(.gg_pag_disabled):hover,
.gg_num_btns_wrap > div:hover,
.gg_num_btns_wrap .gg_pag_disabled {
	background: <?php echo get_option('gg_pag_bg_col_h', '#f0f0f0') ?>;
}
.gg_standard_pag:not(.gg_only_arr) > div:not(.gg_nav_mid):not(.gg_pag_disabled):hover i,
.gg_standard_pag.gg_only_arr > div:not(.gg_pag_disabled):hover i,
.gg_infinite_scroll:hover span,
.gg_num_btns_wrap > div:hover,
.gg_num_btns_wrap .gg_pag_disabled  {
	color: <?php echo get_option('gg_pag_txt_col_h', '#5e5e5e') ?>;	
}
.gg_infinite_scroll:hover,
.gg_standard_pag.gg_only_arr > div:not(.gg_pag_disabled):hover,
.gg_monoblock > div:not(.gg_pag_disabled):hover,
.gg_infinite_scroll:hover,
.gg_num_btns_wrap > div:hover, 
.gg_num_btns_wrap .gg_pag_disabled {
	border: 1px solid  <?php echo get_option('gg_pag_border_col_h', '#999999') ?>;	
}
.gg_dots_pag_wrap > div:hover,
.gg_dots_pag_wrap > div.gg_pag_disabled {	
	box-shadow: 0 -13px 0 0 <?php echo get_option('gg_pag_bg_col_h', '#f0f0f0') ?> inset;
}



/* ************************************************** */


/* standard gallery images */
.gg_standard_gallery .gg_container {
	width: calc(100% + <?php echo (int)get_option('gg_standard_hor_margin', 10) ?>px);
}
.gg_standard_gallery .gg_img {
	margin-right: <?php echo (int)get_option('gg_standard_hor_margin', 10) ?>px;
    margin-bottom: <?php echo (int)get_option('gg_standard_ver_margin', 10) ?>px;
}
<?php if($rtl) : ?>
.gg_standard_gallery .gg_container {
	left: <?php echo (int)get_option('gg_standard_hor_margin', 10) ?>px; 
}
<?php endif;?>

/* columnized gallery images */
.gg_columnized_gallery .gg_container {
	width: calc(100% + <?php echo (int)get_option('gg_colnzd_hor_margin', 10) ?>px);
}
.gg_columnized_gallery .gg_img {
	margin-right: <?php echo (int)get_option('gg_colnzd_hor_margin', 10) ?>px;
    margin-bottom: <?php echo (int)get_option('gg_colnzd_ver_margin', 10) ?>px;
}
<?php if($rtl) : ?>
.gg_columnized_gallery .gg_container  {
	left: <?php echo (int)get_option('gg_colnzd_hor_margin', 10) ?>px; 
}
<?php endif;?>

/* masonry gallery images */
.gg_masonry_gallery .gg_container {
	width: calc(100% + <?php echo (int)get_option('gg_masonry_margin', 10) ?>px);
}
.gg_masonry_gallery .gg_img {
    padding-right: <?php echo (int)get_option('gg_masonry_margin', 10) ?>px;
    margin-bottom: <?php echo (int)get_option('gg_masonry_margin', 10) ?>px;
}
<?php if($rtl) : ?>
.gg_masonry_gallery .gg_container {
	transform: translateX(<?php echo (int)get_option('gg_masonry_margin', 10) - 1 ?>px); 
}
<?php endif;?>

/* photostring gallery images */
.gg_string_gallery .gg_container {
	width: calc(100% + <?php echo (int)get_option('gg_photostring_margin', 10) ?>px + 1px); /* 1px = security addition */
}
.gg_string_gallery .gg_img {
	margin-right: <?php echo get_option('gg_photostring_margin', 10) ?>px;
    margin-bottom: <?php echo get_option('gg_photostring_margin', 10) ?>px;
}
<?php if($rtl) : ?>
.gg_string_gallery .gg_container {
	left: <?php echo (int)get_option('gg_photostring_margin', 10) ?>px; 
}
<?php endif;?>

/* image-to-gallery images */
.gg_itg_wrap:not(.gg_itg_monoimage) .gg_itg_img:nth-child(odd) {
	width: calc(50% - <?php echo ceil((int)get_option('gg_itg_margin', 10) / 2) ?>px);
    margin-right: <?php echo (int)get_option('gg_itg_margin', 10) ?>px;
}
.gg_itg_wrap:not(.gg_itg_monoimage) .gg_itg_img:nth-child(even) {
	width: calc(50% - <?php echo floor((int)get_option('gg_itg_margin', 10) / 2) ?>px);
}
.gg_itg_wrap .gg_itg_img:nth-of-type(3),
.gg_itg_wrap .gg_itg_img:nth-of-type(4) {
	margin-top: <?php echo (int)get_option('gg_itg_margin', 10) ?>px;
}
.gg_itg_wrap .gg_itg_ol_inner {
	color: <?php echo get_option('gg_itg_txt_color', '#fefefe') ?>;
}
.gg_itg_corner_txt .gg_itg_ol_inner,
.gg_itg_main_n_sides .gg_itg_ol_inner {
	background: <?php echo get_option('gg_itg_bg_color', '#333333') ?>;
}
.gg_itg_50_op_ol .gg_itg_ol {
	background: <?php echo get_option('gg_itg_bg_color', '#333333') ?>;
}
.gg_itg_100_op_ol .gg_itg_ol,
.gg_itg_block_over .gg_itg_ol_inner { 
    background: <?php echo get_option('gg_itg_bg_color', '#333333') ?>;
}




/* COLLECTION IMAGES */
.gg_coll_container {
	width: calc(100% + <?php echo (int)get_option('gg_coll_hor_margin', 15) ?>px);
}
.gg_coll_img_wrap {
	margin-bottom: <?php echo (int)get_option('gg_coll_ver_margin', 15) ?>px;
	padding-right: <?php echo (int)get_option('gg_coll_hor_margin', 15) ?>px;
}
.gg_coll_pag_wrap {
	margin-top: <?php echo ((int)get_option('gg_coll_ver_margin', 15) * -1) ?>px;
}
<?php if($rtl) : ?>
.gg_coll_gallery_container .gg_gallery_wrap {
	direction: RTL;
}
<?php endif;?>



/* CAROUSEL */
.gg_car_item_wrap {
	padding-right: <?php echo floor((int)get_option('gg_car_hor_margin') / 2) ?>px;
	padding-left: <?php echo ceil((int)get_option('gg_car_hor_margin') / 2) ?>px;
    padding-top: <?php echo floor((int)get_option('gg_car_ver_margin') / 2) ?>px;
	padding-bottom: <?php echo ceil((int)get_option('gg_car_ver_margin') / 2) ?>px;
}
<?php if(!in_array('dots', (array)get_option('gg_car_hide_nav_elem', array()))) : ?>
.gg_carousel_wrap.slick-slider {
	margin-bottom: 55px;
}
<?php endif; ?>

/* pagination button alignment */
.gg_paginate {
	text-align: <?php echo get_option('gg_pag_align', 'center') ?>;
}


/* ************************************************** */


<?php
// LC MICRO SLIDER
$lcms_borders_sum = (int)get_option('gg_lcms_padding', 7);
$lcms_thumb_sizes = (array)get_option('gg_slider_thumb_sizes', array(100, 75));
$lcms_outline_col = get_option('gg_lcms_border_col', '#ebebeb');
$addit_shadow_space = 0;
?>

.gg_lcms_slider {
    min-height: <?php echo (int)get_option('gg_min_slider_h', 200) ?>px;
}
.gg_lcms_slider .lcms_wrap {
    background: <?php echo get_option('gg_lcms_bg', '#fff'); ?>;
    padding: <?php echo (int)get_option('gg_lcms_padding', 7); ?>px;
    border-radius: <?php echo get_option('gg_lcms_border_radius', 2) ?>px;
    border: <?php echo (int)get_option('gg_lcms_border_w', 1); ?>px solid <?php echo $lcms_outline_col ?>;
}

<?php 
if(get_option('gg_lcms_shadow') == 'soft') : 
$addit_shadow_space = 3;
?>
.gg_lcms_slider .lcms_wrap,
.gg_lcms_has_thumbs .lcms_nav_dots span {
    box-shadow: 0 1px 5px rgba(0,0,0,0.1);
}
<?php 
elseif(get_option('gg_lcms_shadow') == 'heavy') : 
$addit_shadow_space = 7;
?>
.gg_lcms_slider .lcms_wrap,
.gg_lcms_has_thumbs .lcms_nav_dots span {
    box-shadow: 0 3px 7px rgba(0,0,0,0.3);
}
<?php endif; ?> 

.gg_lcms_slider .lcms_container,
.gg_lcms_has_thumbs .lcms_nav_dots span {
    border-radius: <?php echo (get_option('gg_lcms_border_radius', 2)) ? ceil(get_option('gg_lcms_border_radius', 2) / 2) : 0; ?>px;
}
.gg_lcms_slider .lcms_container,
.gg_lcms_slider[data-nav-cmd="h_center_alt"] .lcms_nav {
    top: <?php echo $lcms_borders_sum ?>px;
    left: <?php echo $lcms_borders_sum ?>px;
    bottom: <?php echo $lcms_borders_sum ?>px;
    right: <?php echo $lcms_borders_sum ?>px;
}
.gg_lcms_left_cmd,
.gg_lcms_right_cmd {
    top: <?php echo $lcms_borders_sum + 10 ?>px;
}
.gg_lcms_left_cmd,
.gg_lcms_slider[data-nav-cmd="h_center"] .lcms_prev {
    left: <?php echo $lcms_borders_sum + 10 ?>px;
}
.gg_lcms_right_cmd,
.gg_lcms_slider[data-nav-cmd="h_center"] .lcms_next {
    right: <?php echo $lcms_borders_sum + 10 ?>px;
}
.gg_lcms_slider.gg_lcms_hidden_txt .lcms_content {
    transform: translate3d(0, calc(105% + <?php echo $lcms_borders_sum ?>px), 0);
    opacity: 0;
}

<?php if(get_option('gg_lcms_progressbar')) : ?>
.gg_lcms_progbar {
    <?php echo (get_option('gg_lcms_progressbar') == 'top') ? 'top' : 'bottom'; ?>: <?php echo $lcms_borders_sum ?>px;
    background: <?php echo get_option('gg_lcms_progressbar_col', '#f04a23') ?>;
    left: <?php echo $lcms_borders_sum ?>px;
}
.gg_lcms_slider.lcms_is_playing:not(.lcms_is_sliding) .gg_lcms_progbar {
    animation: gg_lcms_progbar_progress <?php echo (int)get_option('gg_slider_interval', 3000) / 1000 ?>s linear forwards 0s;
}
@keyframes gg_lcms_progbar_progress {
    from {right: 100%;}
    to {right: <?php echo $lcms_borders_sum ?>px;}
}
<?php endif; ?>

<?php if(get_option('gg_slider_extra_nav', 'thumbs') == 'thumbs') : ?>
.gg_lcms_has_thumbs div.lcms_nav_dots {
    bottom: -<?php echo (int)$lcms_thumb_sizes[1] + 10 + $addit_shadow_space ?>px;
}
.gg_lcms_thumbs_shown div.lcms_wrap {
    max-height: calc(100% - <?php echo (int)$lcms_thumb_sizes[1] + 10 + $addit_shadow_space ?>px);
    margin-bottom: <?php echo (int)$lcms_thumb_sizes[1] + 10 + $addit_shadow_space ?>px;
}
.gg_lcms_has_thumbs .lcms_nav_dots span {
    width: <?php echo (int)$lcms_thumb_sizes[0] ?>px;
    height: <?php echo (int)$lcms_thumb_sizes[1] ?>px;
}
<?php 
    elseif(get_option('gg_slider_extra_nav', 'thumbs') == 'dots') : 
    $lcms_dots_col = get_option('gg_lcms_dots_col', '#666');
?>
.gg_lcms_has_dots .lcms_nav_dots span {
	border-color: <?php echo $lcms_dots_col ?>;
}
.gg_lcms_has_dots .lcms_nav_dots span:not(.lcms_sel_dot):hover {	
	box-shadow: 0 -9px 0 0 <?php echo $lcms_dots_col ?> inset;
}
.gg_lcms_has_dots .lcms_nav_dots span.lcms_sel_dot {
	box-shadow: 0 -9px 0 0 <?php echo gg_static::hex2rgba(gg_static::rgba2hex($lcms_dots_col), 0.5) ?> inset;
}
<?php endif; ?>

.gg_lcms_left_cmd > *:not(.lcms_nav),
.gg_lcms_right_cmd > *:not(.lcms_nav),
.gg_lcms_slider .lcms_nav > * {
    background: <?php echo get_option('gg_lcms_cmd_bg', '#fff') ?> !important;
    color: <?php echo get_option('gg_lcms_cmd_col', '#282828') ?>;
}

<?php if(get_option('gg_lcms_nav_cmd_pos', 'h_center') == 'h_center_alt') : ?>
.gg_lcms_slider[data-nav-cmd="h_center_alt"] .lcms_nav > * {
	border: 2px solid <?php echo get_option('gg_lcms_cmd_bg', '#fff') ?>;
    color: <?php echo get_option('gg_lcms_cmd_bg', '#fff') ?>;
}
.gg_lcms_slider .lcms_nav > :hover:before {
    color: <?php echo get_option('gg_lcms_cmd_col', '#282828') ?> !important;
}
.gg_lcms_slider .lcms_nav > :after {
    background: <?php echo get_option('gg_lcms_cmd_bg', '#fff') ?> !important;
}
<?php endif; ?>

.gg_lcms_slider .gg_lcms_slider .lcms_slide div.lcms_content {
    background: <?php echo get_option('gg_lcms_txt_bg', 'rgba(0,0,0, 0.5)') ?>;
    color: <?php echo get_option('gg_lcms_txt_col', '#fdfdfd') ?>;
    font-size: <?php echo (float)get_option('gg_lcms_txt_font_size', 15) . get_option('gg_lcms_txt_font_size_type', 'px') ?>;

    <?php if(get_option('gg_lcms_txt_layout', 'bottom_box') == 'bottom_box') : ?>
    right: auto;
	width: auto;
	bottom: 10px;
	left: 10px;
	max-width: calc(100% - 20px);
    border-radius: <?php echo get_option('gg_lcms_border_radius', 2) ?>px !important;
    <?php endif; ?>
}



<?php
// LC LIGHTBOX

$gg_lb_ol_color = get_option('gg_lb_ol_color', '#111');


// LC Lightbox - openclose effect
if(get_option('gg_lightbox') == 'lcweb') : ?>
/* ************************************************** */
	
    <?php
	switch(get_option('gg_lb_lcl_openclose', 'lcl_zoomin_oc')) {
		
		case 'lcl_fade_oc' :
			?>
            .lcl_fade_oc.lcl_pre_show #lcl_overlay,
            .lcl_fade_oc.lcl_pre_show #lcl_window,
            .lcl_fade_oc.lcl_is_closing #lcl_overlay,
            .lcl_fade_oc.lcl_is_closing #lcl_window {
                opacity: 0 !important;
            }
            .lcl_fade_oc.lcl_is_closing #lcl_overlay {
                transition-delay: .15s !important;
            }
            <?php
			break;
		
		case 'lcl_zoomin_oc' :
			?>
            .lcl_zoomin_oc.lcl_pre_show #lcl_window,
            .lcl_zoomin_oc.lcl_is_closing #lcl_window {
                opacity: 0 !important;
                transform: scale(0.05) translateZ(0) !important;		
            }
            .lcl_zoomin_oc.lcl_is_closing #lcl_overlay {
                opacity: 0 !important;
            }
            <?php
			break;
		
		case 'lcl_bottop_oc' :
			?>
            .lcl_bottop_oc.lcl_pre_show #lcl_overlay,
            .lcl_bottop_oc.lcl_is_closing #lcl_overlay {
                opacity: 0 !important;
            }
            .lcl_bottop_oc.lcl_pre_show #lcl_window {
                transition-property: transform !important;
                opacity: 1 !important;
                transform: translate3d(0, 100vh, 0);
            }
            .lcl_bottop_oc.lcl_is_closing #lcl_window {
                transform: translate3d(0, -100vh, 0);
            }
            <?php
			break;
		
		case 'lcl_bottop_v2_oc' :
			?>
            .lcl_bottop_v2_oc.lcl_pre_show #lcl_window,
            .lcl_bottop_v2_oc.lcl_is_closing #lcl_window {
                opacity: 0 !important;
                transition-timing-function: ease;
            }
            .lcl_bottop_v2_oc.lcl_pre_show #lcl_window {
                top: 40vh;
            }
            .lcl_bottop_v2_oc.lcl_is_closing #lcl_window {
                top: -40vh;
                transform: scale(0.8) translateZ(0);
                transition-delay: 0s !important;	
            }
            .lcl_bottop_v2_oc.lcl_pre_show #lcl_overlay {
                top: 100vh;	
            }
            .lcl_bottop_v2_oc.lcl_is_closing #lcl_overlay {
                top: -100vh;	
            }
            <?php
			break;
		
		case 'lcl_rtl_oc' :
			?>
            .lcl_rtl_oc.lcl_pre_show #lcl_overlay,
            .lcl_rtl_oc.lcl_is_closing #lcl_overlay {
                opacity: 0 !important;
            }
            .lcl_rtl_oc.lcl_pre_show #lcl_window,
            .lcl_rtl_oc.lcl_is_closing #lcl_window {
             	opacity: 1 !important;
                transform: scale(.8) translateZ(0);	
            }
            
            .lcl_rtl_oc.lcl_pre_show #lcl_window {
                left: -100vw;
            }
            .lcl_rtl_oc.lcl_is_closing #lcl_window {
                left: 100vw;  
            }
            .lcl_rtl_oc.lcl_is_closing #lcl_overlay {
                transition-delay: .2s !important;
            }
            <?php
			break;
		
		case 'lcl_horiz_flip_oc' :
			?>
            .lcl_horiz_flip_oc.lcl_pre_show #lcl_overlay,
            .lcl_horiz_flip_oc.lcl_is_closing #lcl_overlay {
                opacity: 0 !important;
            }
            .lcl_horiz_flip_oc.lcl_pre_show #lcl_window,
            .lcl_horiz_flip_oc.lcl_is_closing #lcl_window {
                backface-visibility: hidden;
                transition-timing-function: ease;
            }
            .lcl_horiz_flip_oc.lcl_pre_show #lcl_window {
                transform: rotateY(90deg) perspective(800px);	
            }
            .lcl_horiz_flip_oc.lcl_is_closing #lcl_window {
                transform: rotateY(-90deg) scale(.8) perspective(800px);	
            }
            .lcl_horiz_flip_oc.lcl_is_closing #lcl_overlay {
                transition-delay: .2s !important;
            }
            <?php
			break;
		
		case 'lcl_vert_flip_oc' :
			?>
            .lcl_vert_flip_oc.lcl_pre_show #lcl_overlay,
            .lcl_vert_flip_oc.lcl_is_closing #lcl_overlay {
                opacity: 0 !important;
            }
            .lcl_vert_flip_oc.lcl_pre_show #lcl_window,
            .lcl_vert_flip_oc.lcl_is_closing #lcl_window {
                backface-visibility: hidden;
                transition-timing-function: ease;
            }
            .lcl_vert_flip_oc.lcl_pre_show #lcl_window {
                transform: rotateX(-90deg) perspective(1000px);	
            }
            .lcl_vert_flip_oc.lcl_is_closing #lcl_window {
                opacity: .5 !important;
                transform: rotateX(90deg) scale(.6) perspective(1000px);	
            }
            .lcl_vert_flip_oc.lcl_is_closing #lcl_overlay {
                transition-delay: .2s !important;
            }
            
			<?php
			break;
	}


// photoSwipe lightbox - preloader
elseif(get_option('gg_lightbox') == 'photoswipe') : ?>

/* ************************************************** */

.gg_pswp_loader:before {
    content: "" !important;
    width: 50px;
    height: 50px;
    position: fixed;
    top: calc(50% - 25px);
    left: calc(50% - 25px);
    display: block !important;
    z-index: 99;
    background: #eee;
    border-radius: 100%;
    animation: gg_pswp_loader .7s infinite ease-in-out;
}
@keyframes gg_pswp_loader {
  0% { 
    transform: scale(0);
  } 100% {
    transform: scale(1.0);
    opacity: 0;
  }
}


<?php
// lightcase lightbox 
elseif(get_option('gg_lightbox') == 'lightcase') : ?>

/* ************************************************** */

.gg_lc_ol#lightcase-overlay {
    <?php
    if(strpos($gg_lb_ol_color, 'gradient') !== false) {
        echo 'background: '. $gg_lb_ol_color .' !important;';    
    }
    else {
        echo 'background-color: '. $gg_lb_ol_color .' !important;';
    
    
        if(get_option('gg_lb_ol_pattern', 'none') != 'none') {
            echo '
            background-image: url('.GG_URL.'/js/lightboxes/lc-lightbox/img/patterns/'.get_option('gg_lb_ol_pattern', 'none').'.png) !important;
            background-position: top left !important;
            background-repeat: repeat !important;
            ';
        } 
	}
    ?>
}


<?php // magnific popup 
elseif(get_option('gg_lightbox') == 'mag_popup') : ?>
/* ************************************************** */

.gg_mp .mfp-arrow-left:before, .mfp-arrow-left .mfp-b,
.gg_mp .mfp-arrow-right:before, .mfp-arrow-right .mfp-b  {
	border-color: transparent !important; 
}
.gg_mp.mfp-bg {
	<?php $opacity = ((int)get_option('gg_lb_opacity', 75) == 0) ? 5 : (int)get_option('gg_lb_opacity', 75); ?>
    opacity: <?php echo $opacity / 100 ?>;
	
    <?php
    if(strpos($gg_lb_ol_color, 'gradient') !== false) {
        echo 'background: '. $gg_lb_ol_color .' !important;';    
    }
    else {
        echo 'background-color: '. $gg_lb_ol_color .' !important;';
    
    
        if(get_option('gg_lb_ol_pattern', 'none') != 'none') {
            echo '
            background-image: url('.GG_URL.'/js/lightboxes/lc-lightbox/img/patterns/'.get_option('gg_lb_ol_pattern', 'none').'.png) !important;
            background-position: top left !important;
            background-repeat: repeat !important;
            ';
        } 
	}
    ?>
}
.gg_mp .mfp-image-holder .mfp-content {
    max-width: <?php echo (int)get_option('gg_lb_max_w', 90) ?>% !important;
}
.gg_mp button:hover, .gg_mp button:active, .gg_mp button:focus {
	background: none !important;
    box-shadow: none !important;
    border: none !important;
    padding: none !important;
}
.gg_mag_popup_loader {
    display: inline-block;
    width: 30px;
    height: 30px;
    background: url("<?php echo GG_URL.'/js/lightboxes/magnific-popup/mp_loader.gif'; ?>") no-repeat center center transparent;
}
.gg_mp .mfp-bottom-bar {
	text-shadow: 1px 1px 0px rgba(0, 0, 0, 0.2);
    margin-top: -40px;   
    padding: 13px;
    background: url("<?php echo GG_URL.'/js/lightboxes/magnific-popup/txt_bg.png'; ?>") repeat center center transparent;
}
.gg_mp .mfp-counter {
    right: 13px;
    top: 13px;
}
.gg_mp .mfp-figure {
	display: none;
}
.gg_mp .mfp-figure small {
    color: #D7D7D7;
    line-height: 18px;
}
.gg_mp .mfp-figure small p {
	display: inline;
}
.gg_mp .mfp-title span:first-child {
	font-size: 13px;
    font-style: italic;
}


<?php // imageLightbox
elseif(get_option('gg_lightbox') == 'imagelb') : ?>
/* ************************************************** */

.imagelightbox-overlay {
	<?php $opacity = ((int)get_option('gg_lb_opacity', 75) == 0) ? 5 : (int)get_option('gg_lb_opacity', 75); ?>
    opacity: <?php echo $opacity / 100 ?>;
    
	<?php
    if(strpos($gg_lb_ol_color, 'gradient') !== false) {
        echo 'background: '. $gg_lb_ol_color .' !important;';    
    }
    else {
        echo 'background-color: '. $gg_lb_ol_color .' !important;';
    
    
        if(get_option('gg_lb_ol_pattern', 'none') != 'none') {
            echo '
            background-image: url("'.GG_URL.'/js/lightboxes/lc-lightbox/img/patterns/'.get_option('gg_lb_ol_pattern', 'none').'.png") !important;
            background-position: top left !important;
            background-repeat: repeat !important;
            ';
        } 
	}
    ?>
}


<?php // Simple Lightbox lightbox 
elseif(get_option('gg_lightbox') == 'simplelb') : ?>
/* ************************************************** */

.gg_simplelb.sl-overlay {
    opacity: <?php echo (int)get_option('gg_lb_opacity', 75) / 100; ?> !important;
    
    <?php
    if(strpos($gg_lb_ol_color, 'gradient') !== false) {
        echo 'background: '. $gg_lb_ol_color .' !important;';    
    }
    else {
        echo 'background-color: '. $gg_lb_ol_color .' !important;';
    
    
        if(get_option('gg_lb_ol_pattern', 'none') != 'none') {
            echo '
            background-image: url('.GG_URL.'/js/lightboxes/lc-lightbox/img/patterns/'.get_option('gg_lb_ol_pattern', 'none').'.png) !important;
            background-position: top left !important;
            background-repeat: repeat !important;
            ';
        } 
	}
    ?>
}
.gg_simplelb .sl-navigation button{
	font-size: 36px;
}
.gg_simplelb .sl-close {
	font-size: 34px;
}
.gg_simplelb button:hover,
.gg_simplelb button:focus,
.gg_simplelb button:active {
	background: transparent !important;
    border: none !important;
    padding: 0;
}
.gg_simplelb .sl-image {
	border-radius: <?php echo (int)get_option('gg_lb_radius') ?>px;
    overflow: hidden;
    box-shadow: 0 10px 11px rgba(20, 20, 20, 0.25);
}

  /* styles */
  <?php if(get_option('gg_simplelb_style', 'light') == 'light') : ?>
  .gg_simplelb button {
      color: #5a5a5a;
  }
  .gg_simplelb .sl-spinner {
      border-color: #444;
  }
  .gg_simplelb .sl-caption {
      color: #1a1a1a !important;
      background: #fefefe !important;
  }
  <?php else : ?>
  .gg_simplelb button {
      color: #fdfdfd;
  }
  .gg_simplelb .sl-spinner {
      border-color: #fdfdfd;
  }
  .gg_simplelb .sl-caption {
      color: #fff !important;
      background: #0f0f0f !important;
  }
  <?php endif; ?> 
    

<?php // Light Gallery lightbox 
elseif(get_option('gg_lightbox') == 'lightgall') : ?>
/* ************************************************** */

.gg_lightgall #lightGallery-close {top: 13px !important;}
#lightGallery-close:after {top: 2px !important;}
#lightGallery-action a#lightGallery-prev:before, #lightGallery-action a#lightGallery-next:after {bottom: 2px !important;}
#lightGallery-action a.cLthumb:after {bottom: 3px !important;}
#lightGallery-Gallery .thumb_cont .thumb_info .close {margin-top: -1px !important;}
#lightGallery-Gallery .thumb_cont .thumb_info .close i:after {top: 2px !important;}

.gg_lightgall .title small {
	font-size: 12px;
    font-style: italic;
    font-weight: normal;
}

.gg_lightgall, .gg_lightgall .info.group {
	background: <?php echo $gg_lb_ol_color ?> !important;
}
<?php endif; ?>



<?php 
// custom CSS
echo get_option('gg_custom_css');
?>
