<?php
// REGISTER BLOCK
include_once(GG_DIR .'/settings/field_options.php');


// structure
$defaults = array(
	'gid' => array(
		'label'		=> esc_html__('Which gallery?', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array('' => esc_html__('Select a gallery', 'gg_ml')) + $GLOBALS['gg_guten_galls'],
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'random' => array(
		'label'		=> esc_html__('Random display?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'watermark' => array(
		'label'		=> esc_html__('Use watermark?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'filters' => array(
		'label'		=> esc_html__('Use tags filter?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'search' => array(
		'label'		=> esc_html__('Enable search?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'pagination' => array(
		'label'		=> esc_html__('Pagination system', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'' => esc_html__('Auto - follow global settings', 'gg_ml')
			) + gg_pag_sys(),
		'default' 	=> '',
		'panel'		=> 'main',
	),
);




$defaults = gg_fix_block_defs($defaults);

register_block_type('lcweb/g-gallery', array(
	'editor_script' 	=> 'gg_gall_on_guten',
	'render_callback' 	=> 'gg_gallery_guten_handler',
	'attributes' 		=> $defaults
));


wp_localize_script('wp-blocks', 'gg_gall_defaults', $defaults);
