<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if(!defined('ABSPATH')) exit;



class gg_slider_on_elementor extends Widget_Base {

    public function get_icon() {
        return 'emtr_lcweb_icon';
    }

    public function get_name() {
        return 'g-slider';
    }

    public function get_categories() {
        return array('global-gallery');
    }

    public function get_title() {
        return 'GG - '. esc_html__('Slider', 'gg_ml');
    }



    protected function register_controls() {

        $this->start_controls_section(
            'main',
            array(
                'label' => 'Global Gallery - '. esc_html__('Slider details', 'gg_ml'),
            )
        );


        $this->add_control(
            'gid',
            array(
                'label' 	=> esc_html__('Images source', 'gg_ml'),
                'type' 	=> \Elementor\Controls_Manager::SELECT2,
                'default' => '',
                'options' => array('' => esc_html__('Select a gallery', 'gg_ml') .' ..') + $GLOBALS['gg_emtr_galls']
            )
        );

        $this->add_control(
            'width',
            array(
                'label' => esc_html__("Slider width", 'gg_ml'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => array('%', 'px'),
                'default' => array(
                    'unit' => '%',
                    'size' => 100,
                ),
                'range' => array(
                    '%' => array(
                        'max' => 100,
                        'min' => 10,
                        'step' => 1,
                    ),
                    'px' => array(
                        'max' => 2000,
                        'min' => 300,
                        'step' => 10,
                    ),
                ),
            )
        );

        $this->add_control(
            'height',
            array(
                'label' => esc_html__("Slider height", 'gg_ml'),
                'description' => esc_html__('Using % value, height is proportional to width', 'gg_ml'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => array('%', 'px'),
                'default' => array(
                    'unit' => '%',
                    'size' => 55,
                ),
                'range' => array(
                    '%' => array(
                        'max' => 100,
                        'min' => 10,
                        'step' => 1,
                    ),
                    'px' => array(
                        'max' => 1500,
                        'min' => 100,
                        'step' => 10,
                    ),
                ),
            )
        );

        $this->add_control(
            'crop_method',
            array(
                'label' 	=> esc_html__('Images management method', 'gg_ml'),
                'type' 	=> \Elementor\Controls_Manager::SELECT2,
                'default' => '',
                'options' => gg_slider_crop_methods()
            )
        );

        $this->add_control(
            'no_extra_nav',
            array(
                'label' 		=> esc_html__('Hide extra navigation system?', 'gg_ml'),
                'description'	=> '',
                'type' 		=> Controls_Manager::SWITCHER,
                'default' 	=> '',
                'label_on' 	=> esc_html__('Yes', 'gg_ml'),
                'label_off' 	=> esc_html__('No', 'gg_ml'),
                'return_value' => '1',
            )
        );
        
        $this->add_control(
            'zoom_on_hover',
            array(
                'label' 		=> esc_html__('Zoom image on hover?', 'gg_ml'),
                'description'	=> esc_html__('If checked, zooms the shown image hovering the slider with the cursor', 'gg_ml'),
                'type' 		=> Controls_Manager::SWITCHER,
                'default' 	=> '',
                'label_on' 	=> esc_html__('Yes', 'gg_ml'),
                'label_off' 	=> esc_html__('No', 'gg_ml'),
                'return_value' => '1',
            )
        );
        
        $this->add_control(
            'random',
            array(
                'label' 		=> esc_html__('Random images?', 'gg_ml'),
                'description'	=> esc_html__('Displays images randomly', 'gg_ml'),
                'type' 		=> Controls_Manager::SWITCHER,
                'default' 	=> '',
                'label_on' 	=> esc_html__('Yes', 'gg_ml'),
                'label_off' 	=> esc_html__('No', 'gg_ml'),
                'return_value' => '1',
            )
        );

        $this->add_control(
            'watermark',
            array(
                'label' 		=> esc_html__('Use Watermark?', 'gg_ml'),
                'description'	=> esc_html__('Applies watermark to images (where available)', 'gg_ml'),
                'type' 		=> Controls_Manager::SWITCHER,
                'default' 	=> '',
                'label_on' 	=> esc_html__('Yes', 'gg_ml'),
                'label_off' 	=> esc_html__('No', 'gg_ml'),
                'return_value' => '1',
            )
        );

        $this->add_control(
            'autoplay',
            array(
                'label' 	=> esc_html__('Autoplay slider?', 'gg_ml'),
                'type' 	=> Controls_Manager::SELECT,
                'default' => 'auto',
                'options' => array(
                    'auto' => esc_html__('(as default)', 'gg_ml'),
                    1 => esc_html__('Yes', 'gg_ml'),
                    0 => esc_html__('No', 'gg_ml')
                )
            )
        );
        
        $this->add_control(
		   'hidden_elems',
		   array(
			  'label' 	=> esc_html__('Who can see contents?', 'pc_ml') .'<br/>',
			  'type' 	=> \Elementor\Controls_Manager::SELECT2,
			  'multiple'=> true,
			  'default' => '',
			  'options' => gg_slider_elems_to_hide()
		   )
		);

        $this->end_controls_section();
    }



    ////////////////////////


    protected function render() {
        $vals = $this->get_settings();
        //var_dump($vals);

        // create strings for height and width
        $vals['width'] = $vals['width']['size'].$vals['width']['unit'];
        $vals['height'] = $vals['height']['size'].$vals['height']['unit'];

        $hidden_elems = '';
        if(isset($vals['hidden_elems']) && is_array($vals['hidden_elems'])) {
            $hidden_elems = esc_attr(implode(',', $vals['hidden_elems']));
        }

        $parts = array('gid', 'width', 'height', 'crop_method', 'no_extra_nav', 'zoom_on_hover', 'random', 'watermark', 'autoplay');
        $params = '';

        foreach($parts as $part) {
            $params .= $part.'="';

            if(!isset($vals[$part])) {$vals[$part] = '';}
            $params .= $vals[$part].'" ';	
        }

        echo do_shortcode('[g-slider '. $params .' hidden_elems="'. $hidden_elems .'"]');
    }

}
