<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if(!defined('ABSPATH')) exit;



class gg_gallery_on_elementor extends Widget_Base {
	
	 public function get_icon() {
      return 'emtr_lcweb_icon';
   }
	
	public function get_name() {
		return 'g-gallery';
	}

	public function get_categories() {
		return array('global-gallery');
	}

   public function get_title() {
      return 'GG - '. esc_html__('Gallery', 'gg_ml');
   }
    

   protected function register_controls() {
		include_once(GG_DIR .'/settings/field_options.php');

		$this->start_controls_section(
			'main',
			array(
				'label' => 'Global Gallery - '. esc_html__('Gallery details', 'gg_ml'),
			)
		);
  
  
		$this->add_control(
		   'gid',
		   array(
			  'label' 	=> esc_html__('Choose gallery', 'gg_ml'),
			  'type' 	=> \Elementor\Controls_Manager::SELECT2,
			  'default' => '',
			  'options' => array('' => esc_html__('Select a gallery', 'gg_ml') .' ..') + $GLOBALS['gg_emtr_galls'],
		   )
		);
		
		$this->add_control(
		   'random',
		   array(
			  'label' 		=> esc_html__('Random images?', 'gg_ml'),
			  'description'	=> esc_html__('Displays images randomly', 'gg_ml'),
			  'type' 		=> Controls_Manager::SWITCHER,
			  'default' 	=> '',
			  'label_on' 	=> esc_html__('Yes', 'gg_ml'),
			  'label_off' 	=> esc_html__('No', 'gg_ml'),
			  'return_value' => '1',
		   )
		);
		
		$this->add_control(
		   'watermark',
		   array(
			  'label' 		=> esc_html__('Use Watermark?', 'gg_ml'),
			  'description'	=> esc_html__('Applies watermark to images (where available)', 'gg_ml'),
			  'type' 		=> Controls_Manager::SWITCHER,
			  'default' 	=> '',
			  'label_on' 	=> esc_html__('Yes', 'gg_ml'),
			  'label_off' 	=> esc_html__('No', 'gg_ml'),
			  'return_value' => '1',
		   )
		);
		
		$this->add_control(
		   'filters',
		   array(
			  'label' 		=> esc_html__('Use tags filter?', 'gg_ml'),
			  'description'	=> '',
			  'type' 		=> Controls_Manager::SWITCHER,
			  'default' 	=> '',
			  'label_on' 	=> esc_html__('Yes', 'gg_ml'),
			  'label_off' 	=> esc_html__('No', 'gg_ml'),
			  'return_value' => '1',
		   )
		);
		
		$this->add_control(
		   'search',
		   array(
			  'label' 		=> esc_html__('Enable search?', 'gg_ml'),
			  'description'	=> '',
			  'type' 		=> Controls_Manager::SWITCHER,
			  'default' 	=> '',
			  'label_on' 	=> esc_html__('Yes', 'gg_ml'),
			  'label_off' 	=> esc_html__('No', 'gg_ml'),
			  'return_value' => '1',
		   )
		);
		
		$this->add_control(
		   'pagination',
		   array(
			  'label' 	=> esc_html__('Pagination system', 'gg_ml'),
			  'type' 	=> Controls_Manager::SELECT,
			  'default' => '',
			  'options' => array('' => esc_html__('Auto - follow global settings', 'gg_ml')) + gg_pag_sys()
		   )
		);
		
		$this->end_controls_section();
   }


	
	////////////////////////


	protected function render() {
     	$vals = $this->get_settings();
		//var_dump($vals);

		$parts = array('gid', 'random', 'watermark', 'filters', 'search', 'pagination');
		$params = '';
		
		foreach($parts as $part) {
			$params .= $part.'="';
			
			if(!isset($vals[$part])) {$vals[$part] = '';}
			$params .= $vals[$part].'" ';	
		}
		
		echo do_shortcode('[g-gallery '. $params .']');
	}

}
