<?php
// INITIALIZE DIVI MODULES

class gg_divi_modules {

    // DEEFINE MODULES
    // module slug => php files slug
    private $modules = array(
        'gg_gallery'    => 'gallery',
        'gg_slider'     => 'slider',
        'gg_carousel'   => 'carousel',
        'gg_collection' => 'collection',
        'gg_itg'        => 'itg',
    );
    
    
    
    /* 
     * static method to render elements from both builder and frontend 
     *
     * @param (string) $module_slug
     * @param (array) $vals = values passed by the builder
     */
    public static function front_shortcode_render($module_slug, $vals) {
        switch($module_slug) {
           
            case 'gg_gallery' :
                $shortcode = '[g-gallery '. self::vals_to_sc_params($module_slug, $vals) .']';
                break;
            
            
            case 'gg_slider' :
                $vals['width'] = $vals['lc_width'].$vals['w_type'];
                $vals['height'] = $vals['lc_height'].$vals['h_type'];

                $shortcode = '[g-slider '. self::vals_to_sc_params($module_slug, $vals, array('width', 'height')) .']';
                break;
                
                
            case 'gg_carousel' :
                $vals['height'] = $vals['lc_height'];
                $shortcode = '[g-carousel '. self::vals_to_sc_params($module_slug, $vals, array('height')) .']';
                break;
                
                
            case 'gg_collection' :
                $shortcode = '[g-collection '. self::vals_to_sc_params($module_slug, $vals) .']';
                break;
                
            case 'gg_itg' :
                $vals['width'] = $vals['lc_width'].$vals['w_type'];
                $vals['img_h'] = $vals['img_h'].$vals['h_type'];
                $vals['font_size'] = $vals['lc_font_size'];
                
                $contents = $vals['ol_txt'];
                unset($vals['ol_txt']);
                
                $shortcode = '[g-itg '. self::vals_to_sc_params($module_slug, $vals, array('width', 'img_h', 'font_size')) .']'. $contents .'[/g-itg]';
                break;
                
                
            default :
                return $module_slug .' module not found';  
        }    
        
        //echo $shortcode;
        return do_shortcode($shortcode);
    }
    
    
    
    /* insert here custom actions upon initialization (eg. to create global variable containing galleries array) */
    private function custom_actions() {
        $GLOBALS['gg_divi_icon_path'] = GG_DIR .'/builders_integration/divi_modules/icon.svg';
            
        
        // galleries array
        register_cpt_gg_gallery(); // be sure cpt is registered
        $args = array(
            'post_type' => 'gg_galleries',
            'numberposts' => -1,
            'post_status' => 'publish',
            'orderby' => 'title',
            'order'   => 'ASC',
        );
        $galleries = get_posts($args);

        $GLOBALS['gg_divi_galls'] = array(); 
        foreach($galleries as $gallery) {
            $GLOBALS['gg_divi_galls'][ $gallery->ID ] = $gallery->post_title;
        }
    }
    
    
    
    

    ####################################################################################################
    ## Common methods
    
    
    function __construct() {
        // initialize modules
        add_action('divi_extensions_init', array($this, 'init_modules'));
        
        // ajax handlers
        foreach($this->modules as $key => $name) {
            add_action('wp_ajax_'. $key .'_for_divi', array($this, 'ajax_handler'));
        }
    }
    
    
    /* include divi integration files */
    public function init_modules() {   
        $this->custom_actions();
        
        foreach($this->modules as $module) {
            include_once(__DIR__ .'/divi_modules/'. $module .'/includes/register.php');
        }  
    } 
    
    
    
    public function ajax_handler() {
        if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_nonce')) {
            wp_die('Cheating?');
        };
        
        if(!isset($_POST['module'])) {
            die('module not found');    
        }
        
        echo self::front_shortcode_render($_POST['module'], $_POST['params']);
        die();
    }
    
    
    
    /* 
     * Static method compiling shortcode attributes from values array. Also strips out useless Divi values 
     * @param (array) $exception_indexes = array of extra indexes to save (eg. width and height) 
     */
    private static function vals_to_sc_params($module_slug, $vals, $exception_indexes = array()) {
       
        // strip useless parameters
        if(isset($GLOBALS[$module_slug .'_divi_field_indexes'])) {
            foreach($vals as $key => $val) {
                if(!in_array($key, $GLOBALS[$module_slug .'_divi_field_indexes']) && !in_array($key, (array)$exception_indexes)) {
                    unset($vals[$key]);    
                }
            }
        }
        
        // atts string creator
        $params = '';
        foreach($vals as $key => $val) {
            if($val === 'on' || $val === esc_html__('Yes', 'gg_ml')) {
                $val = 1;
            }
            elseif($val === 'off' || $val === esc_html__('No', 'gg_ml')) {
                $val = 0;
            }
            elseif($val === 'unset') {
                $val = '';
            }

            $params .= $key.'="'. esc_attr((string)$val) .'" ';
        }    
        
        return $params;
    }
}
new gg_divi_modules();








// constant to avoid useless Divi fields on module
if(!defined('LC_DIVI_DEF_OPTS_OVERRIDE')) {
    $indexes = array(
        'link_options',
        'admin_label',
        'background',
        'text',
        'fonts',
        'borders',
        'box_shadow',
        'margin_padding',
        'button',
        'filters',
        'text_shadow',
        'width', 
    );
    $to_return = array();

    foreach($indexes as $i) {
        $to_return[$i] = false;     
    }

    $to_return['width'] = array();
    $to_return['max_width'] = array(
        'use_max_width'        => false,
        'use_module_alignment' => false,
    );
    
    define('LC_DIVI_DEF_OPTS_OVERRIDE', serialize($to_return));
}


