<?php

add_action('cornerstone_register_elements', 'gg_cornerstone_register_elements');
add_filter('cornerstone_icon_map', 'gg_cornerstone_icon_map', 900);


function gg_cornerstone_register_elements() {
	include_once(GG_DIR .'/admin_menu.php'); // be sure tax are registered
	register_cpt_gg_gallery();
	register_taxonomy_gg_collections();
	

	// galleries array
	$args = array(
		'post_type' => 'gg_galleries',
		'numberposts' => -1,
		'post_status' => 'publish',
        'orderby' => 'title',
        'order'   => 'ASC',
	);
	$galleries = get_posts($args);
	
	$GLOBALS['gg_galls_arr'] = array(); 
	foreach($galleries as $gallery) {
    	$GLOBALS['gg_galls_arr'][] = array(
			'value' => $gallery->ID,
			'label' => $gallery->post_title
		);
    }
	
	
	// collections array array (use full list for now)
	$collections = get_terms(array(
        'taxonomy'   => 'gg_collections',
        'hide_empty' => false,
    ));
	
	$GLOBALS['gg_colls_arr'] = array(); 
	foreach($collections as $collection) {
    	$GLOBALS['gg_colls_arr'][] = array(
			'value' => $collection->term_id,
			'label' => $collection->name
		);
    }
    

	///////////////////////////////////////////////////////////
	
	
	cornerstone_register_element('lcweb_gg_gallery', 		'lcweb_gg_gallery', 	GG_DIR .'/builders_integration/cs_elements/gallery');
	cornerstone_register_element('lcweb_gg_collection', 	'lcweb_gg_collection', 	GG_DIR .'/builders_integration/cs_elements/collection');
	cornerstone_register_element('lcweb_gg_slider', 		'lcweb_gg_slider', 		GG_DIR .'/builders_integration/cs_elements/slider');
	cornerstone_register_element('lcweb_gg_carousel', 		'lcweb_gg_carousel', 	GG_DIR .'/builders_integration/cs_elements/carousel');
}


function gg_cornerstone_icon_map( $icon_map ) {
	$icon_map['lcweb_gg_gallery'] 		= GG_URL .'/img/cs_icon.svg';
	$icon_map['lcweb_gg_collection'] 	= GG_URL .'/img/cs_icon.svg';
	$icon_map['lcweb_gg_slider'] 		= GG_URL .'/img/cs_icon.svg';
	$icon_map['lcweb_gg_carousel'] 		= GG_URL .'/img/cs_icon.svg';
	
	return $icon_map;
}
