<?php
// wrapping up operations to be done on plugin's update/activation

class gg_upgrader_operations {
    public static function run() {
        foreach(get_class_methods(__CLASS__) as $method) {
            if($method == 'run') {
                continue;   
            }
            call_user_func(array(__CLASS__, $method));
        }
    }
    ////////////////////////////////////////////////////////////////////////
    
    
    
    // get galleries data to setup connections for v5.0
    public static function gg_setup_connections_v5() {
        if(!get_option('gg_v5_update_done')) {
            include_once(GG_DIR .'/classes/gg_connections_hub.php');

            // retrieve all galleries
            $args = array(
                'numberposts' => -1, 
                'post_type' => 'gg_galleries',
            );
            $posts_array = get_posts($args);

            if(!is_array($posts_array)) {
                update_option('gg_v5_update_done', 1, false);
                return true;
            }
                
            // be sure taxonomy is registered
            gg_conn_taxonomy(); 

            foreach($posts_array as $post) {
                $gid = $post->ID;

                $ch = new gg_connection_hub($gid);
                if($ch->src == 'g_drive' || !in_array($ch->src, $ch->to_consider)) {continue;}

                if(isset($force_continue) && $force_continue) {
                    $force_continue = false;
                    continue;		
                }


                // create connection
                if(!empty($ch->ajax_data)) {
                    // check against already created connections for this source
                    if($term = get_term_by('name', $ch->ajax_data['conn_name'], 'gg_connect_hub')) {
                        update_post_meta($gid, 'gg_connect_id', $term->term_id);
                    }
                    else {
                        $result = $ch->save_connection();
                        if($result === true) {
                            update_post_meta($gid, 'gg_connect_id', $ch->connect_id);	
                        }
                    }
                }
                $ch->ajax_data = array(); // reset
            }
            
            update_option('gg_v5_update_done', 1, false);
        }
    }

    
    
    // update 5.3 - move  old inf_scroll option to gg_pag_system
    public static function inf_scroll_opt_name() {
        if(get_option('gg_infinite_scroll')) {
            update_option('gg_pag_system', 'inf_scroll', false);
            delete_option('gg_infinite_scroll');
        }   
    }
    


    // setup galleries utility metas and clean old watermark cache in V6 
    public static function gg_v6_setup() {
        if(!get_option('gg_v6_update_done')) {

            // retrieve all galleries
            $args = array(
                'numberposts' 	=> -1, 
                'post_type' 	=> 'gg_galleries',
                'post_status'	=> 'any',
                'fields' 		=> 'ids'
            );
            $gallery_ids = get_posts($args);

            if(is_array($gallery_ids)) {
                foreach($gallery_ids as $gid) {
                    $autopop = get_post_meta($gid, 'gg_autopop', true);

                    $images = gg_gall_static::get_data($gid, $autopop);	
                    gg_gall_static::save_data($gid, $images ,$autopop);
                }
            }


            // remove old watermarked images from cache folder
            $cache_dir = GG_DIR .'/cache';

            foreach(scandir($cache_dir) as $file) {
                if(strpos($file, 'gg_watermark') !== false) {
                    @unlink($cache_dir.'/'.$file);	
                }
            }

            update_option('gg_v6_update_done', 1, false);
        }
    }



    // setup v8 options considering old options (eg. img fx)
    public static function gg_v8_setup() {
        if(!get_option('gg_v8_update_done')) {

            // execute only if old options are set
            if(!get_option('gg_thumb_fx')) {
                update_option('gg_v8_update_done', 1, false);
                return true;
            }
            
            $old_fx = get_option('gg_thumb_fx');
            if($old_fx == 'grayscale') {
                update_option('gg_img_fx_behavior', 'default_status', false); 
                update_option('gg_img_fx_grayscale', 100, false);
            }
            elseif($old_fx == 'blur') {
                update_option('gg_img_fx_behavior', 'hover_status', false);  
                update_option('gg_img_fx_blur', 2, false);
            }

            delete_option('gg_thumb_fx');
            update_option('gg_v8_update_done', 1, false);
        }
    }




    // setup v9 options considering old options
    public static function gg_v9_setup() {
        if(!get_option('gg_v9_update_done')) {
            
            // execute only if old options are set
            if(!get_option('gg_slider_thumb_w')) {
                update_option('gg_v9_update_done', 1, false);
                return true;
            }
            
            update_option(
                'gg_slider_thumb_sizes', 
                array(get_option('gg_slider_thumb_w', 100), get_option('gg_slider_thumb_h', 75)),
                false
            );

            update_option(
                'gg_slayout_sizes', 
                array(get_option('gg_thumb_w', 100), get_option('gg_thumb_h', 75)),
                false
            );
            
            update_option(
                'gg_lb_thumb_sizes', 
                array(get_option('gg_lb_thumb_w', 100), get_option('gg_lb_thumb_h', 100)),
                false
            );
            
            
            $to_del = array(
                'gg_slider_thumb_w',
                'gg_slider_thumb_h',
                'gg_thumb_w',
                'gg_thumb_h',
                'gg_lb_thumb_w',
                'gg_lb_thumb_h',
            );
            foreach($to_del as $td) {
                delete_option($td);
            }
            
            update_option('gg_v9_update_done', 1, false);
        }
    }
    
    
}







