<?php 
$ml_key = 'gg_ml';
dike_lc('lcweb', 'gg', true);


// framework engine
include_once(GG_DIR .'/classes/simple_form_validator.php');
include_once(GG_DIR .'/settings/settings_engine.php'); 
include_once(GG_DIR .'/settings/field_options.php'); 
include_once(GG_DIR .'/settings/custom_fields.php');
include_once(GG_DIR .'/settings/structure.php'); 

lcwp_settings_engine::$prod_acronym = 'lcgg';
lcwp_settings_engine::$css_prefix = 'gg_';
lcwp_settings_engine::$ml_key = 'gg_ml';

$engine = new lcwp_settings_engine('gg_settings', $GLOBALS['gg_settings_tabs'], $GLOBALS['gg_settings_structure']);
?>

<div class="wrap lcwp_settings_wrap"> 
    <div class="lcwp_settings_head">
        <h2><?php esc_html_e('Global Gallery Settings', $ml_key) ?></h2>  
        
        <div>
            <?php echo $engine->import_export_btns() ?>
            <form class="lcwp_sf_search_wrap">
                <i class="dashicons dashicons-no-alt"></i>
                <input type="text" name="lcwp_sf_search" value="" placeholder="<?php esc_attr_e('search fields', $ml_key) ?> .." /> 
            </form>
        </div>
    </div>
    
	<?php
    // get fetched data and allow customizations
    if($engine->form_submitted()) {
        $fdata = $engine->form_data;
        $errors = (!empty($engine->errors)) ? $engine->errors : array();


        // GG-FILTER - manipulate setting errors - passes errors array and form values - error subject as index + error text as val
        $errors = apply_filters('gg_setting_errors', $errors, $fdata);	
        
        
        // save or print error
        if(empty($errors)) {
            
            // GG-FILTER - allow data manipulation (or custom actions) before settings save - passes form values
            $engine->form_data = apply_filters('gg_before_save_settings', $fdata); 
            
            // save
            $engine->save_data();

            
            // create custom style css file
          	if(!get_option('gg_force_inline_css')) {
				if(!gg_static::create_frontend_css()) {
					echo '<div class="updated"><p>'. esc_html__('An error occurred during dynamic CSS creation. The code will be used inline anyway', $ml_key) .'</p></div>';
                    $noredirect = true;
				}
				else {
                    delete_option('gg_force_inline_css');
                }
			}	   
			
			
            if(!isset($noredirect)) {
			     $engine->successful_save_redirect();
            }
        }
        
        // compose and return errors
        else {
            echo $engine->get_error_message_html($errors);
        }
    }
	
	
	// if successfully saved
	echo $engine->get_success_message_html();
	
	// print form code
    echo $engine->get_code();
    ?>
</div>




<?php // CUSTOM CSS ?>





<?php // SCRIPTS ?>
<script type="text/javascript">
(function($) { 
    "use strict";       
    
    <?php require_once(GG_DIR .'/settings/mandatory_js.php'); ?>
})(jQuery);     
</script>


<?php
// GG-ACTION - allow extra code printing in settings (for javascript/css)
do_action('gg_settings_extra_code');
?>
