<?php

/////////////////////////////////////
////// PAGINATION ///////////////////
/////////////////////////////////////

function gg_pagination() {
    if(!get_option('gg_no_front_nonce')) {
        if(!isset($_POST['nonce']) || !gg_static::verify_nonce($_POST['nonce'], 'gg_ajax')) {
            wp_die('Nonce check failed - please refresh the page cleaning the browser cache and retry');
        }
    }
    
    include_once(GG_DIR . '/classes/gg_overlay_manager.php');

    /* SC structure
    'gid' 			=> '',
    'overlay' 		=> 'default',

    'filter' 	 => '',
    'search_str' => '',
    'page'		 => 0,
    */

    
    // default shortcode atts
    if(!isset($_POST['gid']) || !absint($_POST['gid'])) {
        wp_die('Gallery ID is missing');
    }
    if(!isset($_POST['gg_pag_vars'])) {
        wp_die('Missing gallery pag vars');
    }
    if(!isset($_POST['gg_page'])) {
        wp_die('wrong page number');
    }
    
    
    $_POST['gg_pag_vars'] = json_decode(wp_unslash($_POST['gg_pag_vars']), true);
    
    $sc_atts = array();
    $sc_atts['gid'] = absint($_POST['gid']);
    $sc_atts['overlay']	= (!isset($_POST['gg_ol'])) ? 'default' : absint($_POST['gg_ol']);


    //// ajax-related shortcode atts
    // is applying a filter? handle matching image indexes
    $sc_atts['filter'] = '';
    if(isset($_POST['gg_filtered_imgs']) && !empty($_POST['gg_filtered_imgs'])) {
        $sc_atts['filter'] = array_map('absint', json_decode(wp_unslash($_POST['gg_filtered_imgs']), true));
        $sc_atts['filter'] = implode(',', $sc_atts['filter']);
    }
    
    // is searching?
    $sc_atts['search_str'] = (isset($_POST['gg_search_str'])) ? sanitize_text_field(wp_unslash($_POST['gg_search_str'])) : '';

    // page
    $sc_atts['page'] = absint($_POST['gg_page']);


    // wrap up atts in a final array 
    $atts = array();
    foreach($sc_atts as $key => $val) {
        $atts[] = $key .'="'. esc_attr($val) .'"';	
    }
    
    $GLOBALS['gg_gallery_is_ajax_mode'] = true;
    $sc = '[g-gallery '. implode(' ', $atts) .']'; 
    wp_die(
        do_shortcode($sc)
    );
}
add_action('wp_ajax_gg_pagination', 'gg_pagination');
add_action('wp_ajax_nopriv_gg_pagination', 'gg_pagination');





//////////////////////////////////////////////////////////////////////////////





////////////////////////////////////////////
////// LOAD GALLERY WITHIN COLLECTION //////
////////////////////////////////////////////

function gg_load_coll_gallery() {
    if(!get_option('gg_no_front_nonce')) {
        if(!isset($_POST['nonce']) || !gg_static::verify_nonce($_POST['nonce'], 'gg_ajax')) {
            wp_die('Nonce check failed - please refresh the page cleaning the browser cache and retry');
        }
    }
    if(!isset($_POST['gdata'])) {
        wp_die('data is missing');
    }
    
    $gdata = json_decode(base64_decode(wp_unslash($_POST['gdata'])), true);
    $gdata = map_deep($gdata, 'sanitize_text_field');
    
    wp_die(
        do_shortcode('[g-gallery gid="'.$gdata['id'].'" random="'.$gdata['rand'].'" filters="'.$gdata['filters'].'" search="'.$gdata['search'].'" watermark="'.$gdata['wmark'].'"]')
    );
}
add_action('wp_ajax_gg_load_coll_gallery', 'gg_load_coll_gallery');
add_action('wp_ajax_nopriv_gg_load_coll_gallery', 'gg_load_coll_gallery');

