<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if(!defined('ABSPATH')) exit;



class gg_collection_on_elementor extends Widget_Base {
	
	 public function get_icon() {
      return 'emtr_lcweb_icon';
   }
	
	public function get_name() {
		return 'g-collection';
	}

	public function get_categories() {
		return array('global-gallery');
	}

   public function get_title() {
      return 'GG - '. esc_html__('Collection', 'gg_ml');
   }



   protected function register_controls() {
		include_once(GG_DIR .'/settings/field_options.php');
		
		
		// collections array
		$collections = get_terms(array(
            'taxonomy'   => 'gg_collections',
            'hide_empty' => false,
        ));
		
		$colls_arr = array(); 
		foreach($collections as $collection) {
			$colls_arr[ $collection->term_id ] = $collection->name;
		}		
       
       
        // collection filters array
        $filters = array(
            '' => '('. esc_html__('none', 'gg_ml') .')'
        ); 
       
        $gall_cats = get_terms(array(
            'taxonomy'   => 'gg_gall_categories',
            'hide_empty' => false,
        ));
        foreach($gall_cats as $cat) {
            $filters[ $cat->term_id ] = $cat->name;
        }
       
       
		////////////////////////////////
		
		
		$this->start_controls_section(
			'main',
			array(
				'label' => 'Global Gallery - '. esc_html__('Collection details', 'gg_ml'),
			)
		);
  
  
		$this->add_control(
		   'cid',
		   array(
			  'label' 	=> esc_html__('Choose collection', 'gg_ml'),
			  'type' 	=> \Elementor\Controls_Manager::SELECT2,
			  'default' => '',
			  'options' => array('' => esc_html__('Select a collection', 'gg_ml') .' ..') + $colls_arr
		   )
		);
		
		$this->add_control(
		   'random',
		   array(
			  'label' 		=> esc_html__('Random images?', 'gg_ml'),
			  'description'	=> esc_html__('Displays images randomly', 'gg_ml'),
			  'type' 		=> Controls_Manager::SWITCHER,
			  'default' 	=> '',
			  'label_on' 	=> esc_html__('Yes', 'gg_ml'),
			  'label_off' 	=> esc_html__('No', 'gg_ml'),
			  'return_value' => '1',
		   )
		);
       
       
       
		$this->add_control(
		   'filter',
		   array(
			  'label' 		=> esc_html__('Allow Filters?', 'gg_ml'),
			  'description'	=> esc_html__('Allows galleries filtering by category', 'gg_ml'),
			  'type' 		=> Controls_Manager::SWITCHER,
			  'default' 	=> '',
			  'label_on' 	=> esc_html__('Yes', 'gg_ml'),
			  'label_off' 	=> esc_html__('No', 'gg_ml'),
			  'return_value' => '1',
		   )
		);
       
            $this->add_control(
               'def_filter',
               array(
                  'label' 	=> esc_html__('Selected filter', 'gg_ml'),
                  'type' 	=> \Elementor\Controls_Manager::SELECT2,
                  'default' => '',
                  'options' => $filters,
                  'condition' => array(
                      'filter' => '1',
                  ),
               )
            );
       
            $this->add_control(
               'hide_all_filter',
               array(
                  'label' 		=> esc_html__('Hide "All" filter?', 'gg_ml'),
                  //'description'	=> esc_html__('Allows galleries filtering by category', 'gg_ml'),
                  'type' 		=> Controls_Manager::SWITCHER,
                  'default' 	=> '',
                  'label_on' 	=> esc_html__('Yes', 'gg_ml'),
                  'label_off' 	=> esc_html__('No', 'gg_ml'),
                  'return_value' => '1',
                  'condition' => array(
                      'filter' => '1',
                  ),
               )
            );
       
		
		$this->add_control(
		   'pag_sys',
		   array(
			  'label' 	=> esc_html__('Pagination system', 'gg_ml'),
			  'type' 	=> Controls_Manager::SELECT,
			  'default' => '',
			  'options' => array(
			  	'' 		=> esc_html__('None', 'gg_ml'),
			  	'auto' 	=> esc_html__('Auto - follow global settings', 'gg_ml')
			  ) + gg_pag_sys()
		   )
		);
		
		$this->add_control(
		   'per_page',
		   array(
			  'label' 	=> esc_html__('How many galleries per page?', 'gg_ml'),
			  'description'	=> esc_html__('Use zero to disable pagination', 'gg_ml'),
			  'type' 	=> Controls_Manager::NUMBER,
			  'min' => 0,
			  'max' => 200,
			  'step' => 1,
			  'default' => 0,
		   )
		);
			
		$this->end_controls_section();
   }


	
	////////////////////////


	protected function render() {
     	$vals = $this->get_settings();
		//var_dump($vals);

		$parts = array('cid', 'random', 'filter', 'def_filter', 'hide_all_filter', 'pag_sys', 'per_page');
		$params = '';
		
		foreach($parts as $part) {
			$params .= $part.'="';
			
			if(!isset($vals[$part])) {$vals[$part] = '';}
			$params .= $vals[$part].'" ';	
		}
		
		echo do_shortcode('[g-collection '. $params .']');
	}

}
