<?php
// DEFINING MODULE STRUCTURE AND FIELDS


class gg_slider_divi_module extends ET_Builder_Module {

	public $slug       = 'gg_slider';
	public $vb_support = 'on';

    
	protected $module_credits = array(
        'module_uri' => 'https://lcweb.it/global-gallery',
        'author'     => 'LCweb',
        'author_uri' => 'https://lcweb.it/',
	);

    
    public function get_advanced_fields_config() {
        return unserialize(LC_DIVI_DEF_OPTS_OVERRIDE);
	}

    
	public function init() {
		$this->name               = 'GG - '. esc_html__('Slider', 'gg_ml');
		$this->icon_path          =  $GLOBALS['gg_divi_icon_path'];
		$this->main_css_element   = '%%order_class%%';	
        
        $this->settings_modal_toggles  = array(
			'general'  => array(
				'toggles' => array(
					'main' => esc_html__('Main Options', 'gg_ml'),
					'styling'      => esc_html__('Styling', 'gg_ml'),
				),
			),
		);
	}
 
    
	public function get_fields() {
        include_once(GG_DIR .'/settings/field_options.php');
        
        $fields =array(
            'gid' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Images source', 'gg_ml'),
				'type'            => 'select',
                'default'         => current(array_keys($GLOBALS['gg_divi_galls'])),
				'default_on_front'=> current(array_keys($GLOBALS['gg_divi_galls'])),
				'options'         => $GLOBALS['gg_divi_galls'],
			),
            'lc_width' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Slider width", 'gg_ml'),
				'type'            => 'range',
                'default'         => 100,
				'default_on_front'=> 100,
				'range_settings'    => array(
					'min'   => 20,
					'max'   => 1000,
                    'step'  => 10
				),
                'validate_unit' => true,
			),
            'w_type' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Width unit type", 'gg_ml'),
				'type'            => 'select',
				'default'         => '%',
				'default_on_front'=> '%',					
				'options'         => array(
				    'px'	=> 'px ('. esc_html__("static", 'gg_ml') .')',
                    '%'	    => '% ('. esc_html__("responsive", 'gg_ml') .')',
				),
			),
            'lc_height' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Slider height", 'gg_ml'),
				'type'            => 'range',
                'default'         => 55,
				'default_on_front'=> 55,
				'range_settings'    => array(
					'min'   => 20,
					'max'   => 1000,
                    'step'  => 5
				),
                'validate_unit' => true,
			),
            'h_type' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Height unit type", 'gg_ml'),
				'type'            => 'select',
				'default'         => '%',
				'default_on_front'=> '%',					
				'options'         => array(
				    'px'	=> 'px ('. esc_html__("static", 'gg_ml') .')',
                    '%'	    => '% ('. esc_html__("responsive", 'gg_ml') .')',
				),
			),
            'crop_method' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Images management method', 'gg_ml'),
				'type'            => 'select',
                'default'         => current(array_keys(gg_slider_crop_methods())),
				'default_on_front'=> current(array_keys(gg_slider_crop_methods())),
				'options'         => gg_slider_crop_methods(),
				'description'     => esc_html__('Select how images will be rendered', 'gg_ml'),
			),
            'no_extra_nav' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Hide extra navigation system?', 'gg_ml'),
				'type'            => 'yes_no_button',
                'default'         => 'off',
				'default_on_front'=> 'off',		
				'options'         => array(
					'off' => esc_html__('No'),
					'on'  => esc_html__('Yes'),
				),
			),
            'zoom_on_hover' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Zoom image on hover?', 'gg_ml'),
				'type'            => 'yes_no_button',
                'default'         => 'off',
				'default_on_front'=> 'off',		
				'options'         => array(
					'off' => esc_html__('No'),
					'on'  => esc_html__('Yes'),
				),
                'description'     => esc_html__('If checked, zooms the shown image hovering the slider with the cursor', 'gg_ml'),
			),
            'random' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Random display?', 'gg_ml'),
				'type'            => 'yes_no_button',
                'default'         => 'off',
				'default_on_front'=> 'off',		
				'options'         => array(
					'off' => esc_html__('No'),
					'on'  => esc_html__('Yes'),
				),
			),	
            'watermark' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Use watermark?', 'gg_ml'),
				'type'            => 'yes_no_button',
                'default'         => 'off',
				'default_on_front'=> 'off',		
				'options'         => array(
					'off' => esc_html__('No'),
					'on'  => esc_html__('Yes'),
				),
			),	
            'autoplay' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Autoplay slider?", 'gg_ml'),
				'type'            => 'select',
				'default'         => 'auto',
				'default_on_front'=> 'auto',					
				'options'         => array(
				    'auto'	=> esc_html__('as default', 'gg_ml'),
                    '1'		=> esc_html__('Yes', 'gg_ml'),
                    '0'		=> esc_html__('No', 'gg_ml'),
				),
			),
		);
        
        
        $GLOBALS[ $this->slug .'_divi_field_indexes'] = array_keys($fields);
        return $fields;
	}


    
    public function render($attrs, $content = null, $render_slug = null) {
        return gg_divi_modules::front_shortcode_render($this->slug, $this->props);  
	}
}

new gg_slider_divi_module;
