<?php

/**
 * Element Controls
 */


// image rows
$img_rows = array();
for($a=1; $a<=10; $a++) {
	$img_rows[] = array('value' => $a, 'label' => $a);	 
} 
 
 

/* FIELDS */
$fields =  array(
	'gid' => array(
		'type'    => 'select',
		'ui' => array(
			'title'   => esc_html__('Gallery', 'gg_ml'),
			'tooltip' => '',
		),
		'options' => array(
			'choices' => $GLOBALS['gg_galls_arr']
		),
	),
	
	'img_max_w' => array(
		'type'    => 'number',
		'ui' => array(
			'title'   => esc_html__('Images max width', 'mg_ml'),
			'tooltip' => ''
		),
	),
	
	'height' => array(
		'type'    => 'number',
		'ui' => array(
			'title'   => esc_html__('Images Height (in pixels)', 'mg_ml'),
			'tooltip' => esc_html__("Carousel images height in pixels", 'mg_ml')
		),
	),
	
	'h_type' => array(
		'type'    => 'select',
		'ui' => array(
			'title'   => esc_html__('Height type', 'gg_ml'),
			'tooltip' => '',
		),
		'options' => array(
			'choices' => array(
				array('value' => 'px', 'label' => 'px'),
				array('value' => '%', 'label' => '%'),
			)
		),
	),
	
	'rows' => array(
		'type'    => 'select',
		'ui' => array(
			'title'   => esc_html__('Rows', 'gg_ml'),
			'tooltip' => esc_html__("Choose how many image rows to use", 'mg_ml'),
		),
		'options' => array(
			'choices' => $img_rows
		),
	),
	
	'multiscroll' => array(
		'type'    => 'toggle',
		'ui' => array(
			'title'   => esc_html__('Multiple Scroll?', 'gg_ml'),
			'tooltip' => esc_html__('Slides multiple images per time', 'gg_ml'),
		),
	),
	
	'center' => array(
		'type'    => 'toggle',
		'ui' => array(
			'title'   => esc_html__('Center mode?', 'gg_ml'),
			'tooltip' => esc_html__('Enables center display mode', 'gg_ml')
		),
	),
	
	'nocrop' => array(
		'type'    => 'toggle',
		'ui' => array(
			'title'   => esc_html__('Avoid images crop?', 'gg_ml'),
			'tooltip' => esc_html__('Just downscales images', 'gg_ml')
		),
	),
	
	'random' => array(
		'type'    => 'toggle',
		'ui' => array(
			'title'   => esc_html__('Random display?', 'gg_ml'),
			'tooltip' => esc_html__('Display images randomly', 'gg_ml'),
		),
	),
	
	'watermark' => array(
		'type'    => 'toggle',
		'ui' => array(
			'title'   => esc_html__('Use Watermark?', 'gg_ml'),
			'tooltip' => esc_html__('Apply watermark to images (if available)', 'gg_ml'),
		),
	),

	'autoplay' => array(
		'type'    => 'select',
		'ui' => array(
			'title'   => esc_html__('Autoplay', 'gg_ml'),
			'tooltip' => '',
		),
		'options' => array(
			'choices' => array(
				array('value' => 'auto',	'label' => esc_html__('(as default)', 'gg_ml')),
				array('value' => 1, 		'label' => esc_html__('Yes', 'gg_ml')),
				array('value' => 0,			'label' => esc_html__('No', 'gg_ml')),
			)
		),
	),
);


return $fields;
